/*
 * Decompiled with CFR 0.152.
 */
package salesmansolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import salesmansolver.Gene;

public class Chromosome {
    private final ArrayList<Gene> route = new ArrayList();
    private double fitness;
    private double routeDistance;

    Chromosome() {
        this.fitness = 0.0;
    }

    Chromosome(Gene[] array) {
        for (Gene g : array) {
            this.route.add(g);
        }
        this.fitness = 0.0;
    }

    Chromosome(Chromosome another) {
        for (Gene g : another.route) {
            this.route.add(g);
        }
        this.fitness = another.getFitness();
        this.routeDistance = another.getRouteDistance();
    }

    public void add(Gene g) {
        this.route.add(g);
    }

    public void remove(int i) {
        this.route.remove(i);
    }

    public Integer size() {
        return this.route.size();
    }

    public Gene get(int i) {
        return this.route.get(i);
    }

    public void swap(int i, int j) {
        Collections.swap(this.route, i, j);
    }

    public LinkedHashSet<Gene> subSet(int start, int end) {
        LinkedHashSet<Gene> result = new LinkedHashSet<Gene>();
        for (int i = start; i <= end; ++i) {
            result.add(this.route.get(i));
        }
        return result;
    }

    private double calculateFitness() {
        Gene to;
        Gene from;
        double routeDistance = 0.0;
        for (int i = 0; i < this.route.size() - 1; ++i) {
            from = this.route.get(i);
            to = this.route.get(i + 1);
            routeDistance += from.distance(to);
        }
        from = this.route.get(this.route.size() - 1);
        to = this.route.get(0);
        this.fitness = 1000.0 / (routeDistance += from.distance(to));
        this.routeDistance = routeDistance;
        return this.fitness;
    }

    public double getFitness() {
        return this.calculateFitness();
    }

    public double getRouteDistance() {
        return this.routeDistance;
    }

    public String toString() {
        return this.route.toString() + " : " + this.routeDistance;
    }
}

